<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
function search_contact_callback($plugin)
{
    if (stripos($plugin ['title'], $_GET['kw']) !== false) {
        return true;
    }
    return false;
}

function clean_control_name($str)
{
    return strtolower(preg_replace(array('/[^a-zA-Z0-9-]/'), array(''), $str));
}

function get_value_control($name)
{
    $clean = clean_control_name($name);
    if (isset($_POST[$clean])) {
        $data = $_POST[$clean];
        return is_array($data) ? strip_tags(implode(', ', $data)) : $data;
    }
    return '';
}

function form_btn($data = '', $extra = '')
{
    return '<input ' . _parse_attributes($data, array()) . $extra . " />\n";
}

function sc_clean_form_item($data)
{
    if (!empty($data)) {
        return array_filter($data);
    }
    return $data;
}

function sc_input_text($data)
{
    return form_input($data);
}

function change_key_value_array($data)
{
    return $data[$data] = $data;
}

function sc_input_collection($data)
{
    $html = '';
    if (!isset($data['items'])) {
        return;
    }
    if (!isset($data['name'])) {
        return;
    }

    if (!isset($data['type'])) {
        return;
    }
    $name = $data['name'];
    $items_tmp = explode('|', $data['items']);
    if (empty($items_tmp)) {
        return '';
    }
    foreach ($items_tmp as $value) {
        $items[$value] = $value;
    }
    $type = $data['type'];
    unset($data['items']);
    if ($type === 'radio' || $type === 'checkbox') {
        $method = 'form_' . $type;
        $data['name'] = $type === 'checkbox' ? "{$data['name']}[]" : $data['name'];
        unset($data['required']);
        foreach ($items as $v) {
            $data['value'] = $v;
            $html .= '<label class="item-check">' . $method($data) . " {$v}" . '</label>';
        }
    } else {
        $html .= form_dropdown($name, $items);
    }
    return $html;
}

function sc_button($data)
{
    return form_btn($data);
}

function sc_acceptance($data)
{
    $data['type'] = 'checkbox';
    $data['name'] = 'acceptance';
    $data['value'] = 1;
    return '<label class="item-check">' . form_checkbox($data) . (isset($data['label']) ? " {$data['label']}" : '') . '</label>';
}

function sc_captcha()
{
    return recaptcha_get_html(Pf::setting()->get_element_value('general', 'recaptcha_public_key'));
}

function sc_build_form_item($data)
{
    global $contactform_validator_error;
    $texts = array('text', 'number', 'date', 'hidden', 'age', 'email', 'url');
    $multiple = array('dropdown', 'checkbox', 'radio');
    $button = array('button', 'submit', 'reset');
    $data = sc_clean_form_item($data);
    if (!isset($data['type'])) {
        return;
    } elseif ($data['type'] === 'captcha') {
        $data['name'] = 'captcha';
    } elseif ($data['type'] === 'acceptance') {
        $data['name'] = 'acceptance';
    }
    if (!isset($data['name'])) {
        return;
    }
    $type = $data['type'];
    $control = "";
    unset($data['required']);
    if ($type === 'captcha') {
        $control = sc_captcha($data);
        $data['name'] = 'captcha';
    } else {
        $data['name'] = clean_control_name($data['name']);
    }

    if ($type === 'textarea') {
        $value = isset($data['value']) ? $data['value'] : '';
        unset($data['value']);
        $control = form_textarea($data, $value);
    }
    if (in_array($type, $texts)) {
        if ($type === 'date') {
            $data['type'] = 'text';
            $data['data-type'] = 'date';
        }
        $control = sc_input_text($data);
    }
    if (in_array($type, $multiple)) {
        $control = sc_input_collection($data);
    }
    if (in_array($type, $button)) {
        $control = sc_button($data);
    }
    if ($type == 'acceptance') {
        $control = sc_acceptance($data);
    }
    return $control . alert_error_validator($data['name'], $contactform_validator_error, true);
}

function sc_get_value_from($data)
{
    return isset($data['name']) ? get_value_control($data['name']) : '';
}

function sc_build_message($data)
{
    $output = array();
    preg_match_all('/\{(.*?)\}/', $data, $output);
    if (count($output) === 2) {
        foreach ($output[1] as $k => $v) {
            $tmp = get_value_control($v);
            $data = str_replace($output[0][$k], $tmp, $data);
        }
    }
    return $data;
}

function sc_get_value_input($key)
{
    return isset($_POST[$key]) ? $_POST[$key] : '';
}
